local assets=
{
	Asset("ANIM", "anim/nightmarehelmet.zip")
}

local function OnBlocked(owner, data) 
local attacker = data.attacker and data.attacker.components.health and not data.attacker:HasTag("thorny")
    owner.SoundEmitter:PlaySound("dontstarve/wilson/hit_nightarmour") 
	if attacker then
		local damage_amount = data.attacker.components.combat.defaultdamage*0.15
		--local damageback = damage_amount *0.15
		data.attacker.components.health:DoDelta(-damage_amount)
	end
end

local function onequip(inst, owner) 
		owner.AnimState:OverrideSymbol("swap_hat", "nightmarehelmet", "swap_hat")
		owner:AddTag("NightmareOne")
        owner.AnimState:Show("HAT")
        owner.AnimState:Show("HAT_HAIR")
        owner.AnimState:Hide("HAIR_NOHAT")
        owner.AnimState:Hide("HAIR")
		inst:ListenForEvent("blocked", OnBlocked, owner)
		inst:ListenForEvent("attacked", OnBlocked, owner)
		SpawnPrefab("statue_transition_2").Transform:SetPosition(inst:GetPosition():Get())	
		inst.SoundEmitter:PlaySound("dontstarve/wilson/attack_nightsword")
end

local function onunequip(inst, owner) 
		owner:RemoveTag("NightmareOne")
        owner.AnimState:Hide("HAT")
        owner.AnimState:Hide("HAT_HAIR")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")
		inst:RemoveEventCallback("blocked", OnBlocked, owner)
		inst:RemoveEventCallback("attacked", OnBlocked, owner)
		SpawnPrefab("statue_transition_2").Transform:SetPosition(inst:GetPosition():Get())	
		inst.SoundEmitter:PlaySound("dontstarve/wilson/attack_nightsword")
end


local function OnTakeDamage(inst, damage_amount, absorbed, leftover)
	local owner = inst.components.inventoryitem.owner
	if owner then
		local sanity = owner.components.sanity
		if sanity then
			local unsaneness = damage_amount * TUNING.ARMOR_SANITY_DMG_AS_SANITY*1.1
			sanity:DoDelta(-unsaneness, false)
			SpawnPrefab("statue_transition").Transform:SetPosition(inst:GetPosition():Get())	
			inst.SoundEmitter:PlaySound("dontstarve/wilson/attack_nightsword")
		end
	end
end

local function fn(Sim)
	local inst = CreateEntity()
    
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
	inst.entity:AddSoundEmitter()
	
	inst.AnimState:SetBank("featherhat")
	inst.AnimState:SetBuild("nightmarehelmet")
	
    inst.AnimState:PlayAnimation("anim")
    
    inst:AddTag("sanity")
    
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "nightmarehelmet"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/nightmarehelmet.xml"
    --inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/nightarmour"
    
    inst:AddComponent("armor")
    inst.components.armor:InitCondition(TUNING.ARMOR_SANITY, TUNING.ARMOR_SANITY_ABSORPTION*0.5)
	inst.components.armor.ontakedamage = OnTakeDamage
	
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
    
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	
	inst.entity:AddLight()
	inst.Light:SetRadius(1.5) --range
    inst.Light:SetFalloff(0.8) --fade distance
    inst.Light:SetIntensity(0.3) --brightness
	inst.Light:SetColour(130/255,0/255,100/255) --color
	inst.Light:Enable(false)

	inst:DoPeriodicTask(1/100, function()
	if inst.components.equippable.isequipped and GetPlayer():HasTag("NightmareOne") and GetPlayer():HasTag("NightmareTwo") and GetPlayer():HasTag("NightmareThree") then
	inst.Light:Enable(true)
	else
	inst.Light:Enable(false)
	end
	end)

	
	if IsDLCEnabled(REIGN_OF_GIANTS) then
	inst.components.equippable.dapperness = TUNING.CRAZINESS_MED *1.1
	else
	inst:AddComponent("dapperness")
	inst.components.dapperness.dapperness = TUNING.CRAZINESS_MED *1.1
	end
    
    return inst
end

return Prefab( "common/inventory/nightmarehelmet", fn, assets) 